// HDLM 8 API
// Version 3.0.8
// License: GNU Lesser General Public License (LGPL), see http://www.gnu.org/licenses/lgpl-3.0.de.html
#ifndef __HDLM_API__
#define __HDLM_API__

// LEGEND:
// * host-to-app only
// ° app-to-host only

#define	COMMAND_BUS_MUTE			(1)		//	1,<from_connid>,<busid>,<0=unmute|1=mute>
#define	COMMAND_BUS_GAIN			(2)		//	2,<from_connid>,<busid>,<gain dB>
#define	COMMAND_BUS_PHASE			(3)		//	3,<from_connid>,<busid>,<0=normal|1=reversed>
#define	COMMAND_BUS_COMP_THRES		(4)		//	4,<from_connid>,<busid>,<threshold dBFS>
#define	COMMAND_BUS_COMP_RATIO		(5)		//	5,<from_connid>,<busid>,<ratio 1:n>
#define	COMMAND_BUS_COMP_KNEE		(6)		//	6,<from_connid>,<busid>,<knee span dB>
#define	COMMAND_BUS_PEAK_OVERSHOOT	(7)		//	7,<from_connid>,<busid>,<dB over threshold>
#define	COMMAND_BUS_PATCH			(8)		//	8,<from_connid>,<busid>,<bitset>
#define	COMMAND_BUS_LABEL			(9)		//	9,<from_connid>,<busid>,<string>
#define	COMMAND_BUS_GROUP_LOCAL		(10)	//	10,<from_connid>,<busid>,<groupid>
#define	COMMAND_BUS_GROUP_NET		(11)	//	11,<from_connid>,<busid>,<groupid>
#define	COMMAND_BUS_GEQ_SET			(12)	//	12,<from_connid>,<busid>,<geqid[0..30]>,<gain dB>
#define	COMMAND_BUS_EQ_CURVE		(13)	// *13,0,<busid>,<mag dB 0>,<mag dB 1>,...,<mag dB CURVES_WIDTH-1>
#define	COMMAND_BUS_EQ_FLAGS		(14)	//	14,<from_connid>,<busid>,<flags BUS_EQ_FLAGS_xxx>
#define	COMMAND_BUS_GEQ_FLAT		(15)	// °15,<from_connid>,<busid>
#define	COMMAND_BUS_PEQ_SET			(16)	//	16,<from_connid>,<busid>,<peqid[0..SYS_BUS_PEQ_COUNT-1]>,<freq>,<q>,<gain dB>,<bypass>
#define	COMMAND_BUS_SHELFEQ_SET		(17)	//	17,<from_connid>,<busid>,<shelfeqid[0..SYS_BUS_SHELFEQ_COUNT-1]>,<freq>,<gain dB>,<bypass>
#define	COMMAND_BUS_HPF_SET			(18)	//	18,<from_connid>,<busid>,<freq>,<type HPF_TYPE_xxx>,<bypass>
#define COMMAND_BUS_ID_FIRST		COMMAND_BUS_MUTE
#define COMMAND_BUS_ID_LAST			COMMAND_BUS_HPF_SET

#define	COMMAND_SYS_SERVICEMODE		(20)	//	20,<from_connid>,<1=fixed-on>
#define	COMMAND_SYS_NETWORK			(21)	//	21,<from_connid>,<°0|*actual-ip(decimal integer value of hex aa.bb.cc.dd)>,<0=auto|1=master|2=client|3=static 1<<4 for disable DNS *: 1<<8 for WLAN-AP enabled>,<ip-0>,<ip-1>,<ip-2>,<ip-3>,<netmask-bits>,<gateway-0>,<gateway-1>,<gateway-2>,<gateway-3>
#define	COMMAND_SYS_DEVICENAME		(22)	//	22,<from_connid>,<name>
#define	COMMAND_SYS_DELAYUNIT		(23)	//	23,<from_connid>,<0=meter|1=feet|2=milliseconds>,<temperature K>,<*max value>
#define	COMMAND_SYS_AMPLIFIERS		(24)	//	24,<from_connid>,<outid>,<gain>,<peak voltage>
#define	COMMAND_SYS_MESSAGE			(25)	// *25,<from_connid>,<type 0=info|1=warning|2=error>,<message>
#define	COMMAND_SYS_FWUPDATE		(26)	//  26,<from_connid>,<key=685313405>
#define	COMMAND_SYS_SECURITY		(27)	//  27,<from_connid>,<flags SYS_SECURITY_xxx or °-1 for info>
#define	COMMAND_SYS_HELLOWORLD		(28)	//	28,0,<ip-0>,<ip-1>,<ip-2>,<ip-3>,<device name>	[will be sent over udp frequently]
#define	COMMAND_SYS_INPUTSTATE		(29)	// *29,<analog_overflow_bits: 0|1=A|2=B|3=A+B>,<digital_state SYS_MISC_DIGITAL_STATE_xxx>
#define COMMAND_OUT_METER			(30)	// *30,<outputchannel>,<peak dBFS>,<gr dBFS>
#define COMMAND_BUS_METER			(31)	// *31,<busid>,<peak dBFS>,<gr dBFS>

#define	COMMAND_OUT_GROUPING		(32)	// *32,<from_connid>,<group_lsp ch0>,...,<group_lsp ch7>,<lsp id ch0>,...,<lsp id ch7>
#define	COMMAND_OUT_GROUP_CONFIG	(33)	// *33,<from_connid>,<group_lsp>,<outmode ch0>,...,<outmode ch7>
#define	COMMAND_OUT_GROUP_LSP_LABEL	(34)	//  34,<from_connid>,<group_lsp>,<label>
#define	COMMAND_OUT_GROUP_LABEL		(35)	//	35,<from_connid>,<group_lsp>,<label>
#define	COMMAND_OUT_GROUP_LSP_SET	(36)	// °36,<from_connid>,<group_lsp>,<id_lsp>
#define	COMMAND_OUT_GROUP_MUTE		(37)	// °37,<from_connid>,<group_lsp>,<0=unmute|1=mute>
#define	COMMAND_OUT_GROUP_GAIN		(38)	//	38,<from_connid>,<group_lsp>,<gain dB>
#define	COMMAND_OUT_GROUP_PHASE		(39)	//	39,<from_connid>,<group_lsp>,<0=normal|1=reversed>
#define	COMMAND_OUT_GROUP_GRP_LOCAL	(40)	//	40,<from_connid>,<group_lsp>,<groupid>
#define	COMMAND_OUT_GROUP_GRP_NET	(41)	//	41,<from_connid>,<group_lsp>,<groupid>
#define	COMMAND_OUT_GROUP_INPUT		(42)	//	42,<from_connid>,<group_lsp>,<input bus id>
#define	COMMAND_OUT_GROUP_DELAY		(43)	//  43,<from_connid>,<group_lsp>,<delay>		[delay in units of COMMAND_SYS_DELAYUNIT]
#define	COMMAND_OUT_GROUP_DELAY_MS	(50)	// *50,<from_connid>,<group_lsp>,<delay_ms>		[calculated delay in milliseconds as information]
#define	COMMAND_OUT_MUTE			(44)	//	44,<from_connid>,<outid>,<0=unmute|1=mute>	[if (outid==-1 && mute) then ALARM MUTE for 5s]
#define	COMMAND_OUT_GROUP_PEQ_SET	(45)	//	45,<from_connid>,<group_lsp>,<peqid[0..SYS_OUT_PEQ_COUNT-1]>,<freq>,<q>,<gain dB>,<bypass>
#define	COMMAND_OUT_GROUP_SHELFEQ_SET (46)	//	46,<from_connid>,<group_lsp>,<shelfeqid[0..SYS_OUT_SHELFEQ_COUNT-1]>,<freq>,<gain dB>,<bypass>
#define	COMMAND_OUT_GROUP_HPF_SET	(47)	//	47,<from_connid>,<group_lsp>,<freq>,<type HPF_TYPE_xxx>,<bypass>
#define	COMMAND_OUT_GROUP_EQ_CURVE	(48)	// *48,0,<group_lsp>,<mag dB 0>,<mag dB 1>,...,<mag dB CURVES_WIDTH-1>
#define	COMMAND_OUT_GROUP_EQ_FLAGS	(49)	//	49,<from_connid>,<group_lsp>,<flags OUT_GROUP_EQ_FLAGS_xxx>
#define	COMMAND_OUT_GROUP_ID_FIRST	COMMAND_OUT_GROUP_LSP_LABEL
#define	COMMAND_OUT_GROUP_ID_LAST	COMMAND_OUT_GROUP_DELAY_MS

#define	COMMAND_SYS_FLAGS			(62)	//  62,<from_connid>,<SYS_MISC_FLAGS_xxx>
#define	COMMAND_SYS_DIGITALMODE		(63)	//  63,<from_connid>,<SYS_MISC_DIGITAL_MODE_xxx>

#define	COMMAND_LSP_FILE			(64)	//  64,<from_connid>,<lspid>,<id_parent>,<version>,<°is_folder|0>,<is_locked>,<°ways|*unlock_code>,<label>
#define	COMMAND_LSP_FILE_START		(65)	// *65,<from_connid>,<partial>
#define	COMMAND_LSP_FILE_END		(66)	// *66,<from_connid>
#define	COMMAND_LSP_PROP			(67)	//	67,<from_connid>,<lspid>,<°unlock_code|0>,<config_properties>
#define COMMAND_LSP_RESVD			(68)	// 	(reserved)
#define	COMMAND_LSP_COEF			(69)	//* 69,<from_connid>,<lspid>,<ways>,<filterperway>,<cabinet>,<gain_phase>,<a1>,<a2>,<b0>,<b1>,<b2>,... [5*ways*filterperway coefs + (cabinet, gain_phase per way)]
#define	COMMAND_LSP_NEW				(70)	// °70,<from_connid>,<is_folder>,<id_parent|0>
											// *70,<from_connid>,<last_insterted_lsp_id>
#define	COMMAND_LSP_REMOVE			(71)	// °71,<from_connid>,<lspid>
#define	COMMAND_PLY_FILE			(80)	// *80,<from_connid>,<file_id>,<length_s>,<label>
#define	COMMAND_PLY_FILE_START		(81)	// *81,<from_connid>,<partial>
#define	COMMAND_PLY_FILE_END		(82)	// *82,<from_connid>
#define	COMMAND_PLY_START			(83)	//	83,<from_connid>,<file_id>
#define	COMMAND_PLY_STOP			(84)	//	84,<from_connid>
#define	COMMAND_PLY_SEEK			(85)	//	85,<from_connid>,<pos_s>
#define	COMMAND_PLY_VOLUME			(86)	//	86,<from_connid>,<gain_db>
#define	COMMAND_PRJ_FILE			(96)	//	96,<from_connid>,<project_id>,<is_locked>,<label>
#define	COMMAND_PRJ_FILE_START		(97)	// *97,<from_connid>,<partial>
#define	COMMAND_PRJ_FILE_END		(98)	// *98,<from_connid>
#define	COMMAND_PRJ_LOAD			(99)	// °99,<from_connid>,<project_id>
#define	COMMAND_PRJ_STAT			(100)	// 100,<from_connid>,<project_id>,<is_locked>,<*saved_is_locked(lock status of the saved project)|°0>,<*is_dirty|°0>,<label>
#define	COMMAND_PRJ_SAVE			(101)	//°101,<from_connid>,<unlock_code>
#define	COMMAND_PRJ_SAVEAS			(102)	//°102,<from_connid>,<overwrite project_id|0=new>,<new_label (if new set)>
#define	COMMAND_PRJ_DELETE			(103)	//°103,<from_connid>,<project_id>		[delete function must be unlocked and locked by COMMAND_PRJ_DELETE_LOCK]
#define	COMMAND_PRJ_NEW				(104)	//°104,<from_connid>,<label>
#define	COMMAND_PRJ_FILES_DIRTY		(105)	//*105,<from_connid> [the project db has changed. clients have to refresh via INFO_PRJ_TREE]
#define	COMMAND_PRJ_DELETE_LOCK		(106)	//°106,<from_connid>,<lock|unlock key>	[unlock key=30947321; all other=lock]
#define	COMMAND_PRJ_USB_EXPORT_ACK	(107)	//*107,<from_connid>,<project_id>		
#define	COMMAND_PRJ_USB_IMPORT_ACK	(108)	//*108,<from_connid>,<file_id>			
#define	COMMAND_PRJ_USB_FILE		(109)	//*109,<from_connid>,<file_id>,<reserved>,<label>
#define	COMMAND_PRJ_USB_FILE_START	(110)	//*110,<from_connid>,<partial>
#define	COMMAND_PRJ_USB_FILE_END	(111)	//*111,<from_connid>

#define	COMMAND_SYS_WLAN_PASSWORD	(112)	// 112,<from_connid>,<password>

#define	COMMAND_BUS_COMP_ATTACK		(113)	// 113,<from_connid>,<busid>,<attack ms>
#define	COMMAND_BUS_COMP_RELEASE	(114)	// 114,<from_connid>,<busid>,<release ms>
#define	COMMAND_BUS_PEAK_RELEASE	(115)	// 115,<from_connid>,<busid>,<release ms|0=auto>
#define COMMAND_LSP_ERR				(116)	//*116,<from_connid>,<lspid>,<lspconfig_errors>
#define	COMMAND_LSP_DUPLICATE		(117)	//°117,<from_connid>,<lspid>
#define	COMMAND_LSP_MOVE			(118)	//°118,<from_connid>,<lspid>,<targetfolderid>

#define	COMMAND_PRJ_DESC			(119)	// 119,<from_connid>,<*project_id|°-1=current>,<description>

#define	COMMAND_BUS_COPY			(120)	//°120,<from_connid>,<dest_busid>,<source_busid>,<what_flags(BUS_COPY_xxx)>
#define	COMMAND_OUT_GROUP_COPY		(121)	//°121,<from_connid>,<dest_group_lsp>,<source_group_lsp>,<what_flags(OUT_GROUP_COPY_xxx)>

#define	COMMAND_SYS_INFO			(122)	//*122,... (same like INFO_VERSION)
#define COMMAND_SYS_ALARM_MSG		(123)	//*123,<from_connid>,<text string>	(DRAWS TEXT STRING ON CENTER SCREEN FOR FEW SECONDS)

#define	COMMAND_BUS_GEQ_IBT_SET		(124)	//	124,<from_connid>,<busid>,<bits plus (32 bit int)>,<bits minus(32 bit int)> (IN BAND TUNING BIT MASK)

#define COMMAND_LAST				(124)

#define	BUS_COPY_PHYSICALINPUTS		(1<<0)
#define	BUS_COPY_GAIN				(1<<1)
#define	BUS_COPY_POLARITY			(1<<2)
#define	BUS_COPY_DYNAMICS			(1<<3)
#define	BUS_COPY_EQ_HPF				(1<<4)
#define	BUS_COPY_EQ_PEQ				(1<<5)
#define	BUS_COPY_EQ_SHELF			(1<<6)
#define	BUS_COPY_EQ_GEQ				(1<<7)

#define	OUT_GROUP_COPY_INPUTBUS		(1<<0)
#define	OUT_GROUP_COPY_GAIN			(1<<1)
#define	OUT_GROUP_COPY_POLARITY		(1<<2)
#define	OUT_GROUP_COPY_DELAY		(1<<3)
#define	OUT_GROUP_COPY_EQ_HPF		(1<<4)
#define	OUT_GROUP_COPY_EQ_PEQ		(1<<5)
#define	OUT_GROUP_COPY_EQ_SHELF		(1<<6)

#define	BUS_EQ_FLAGS_GEQ_BYPASS		(1<<2)	//	bypass geq
#define	BUS_EQ_FLAGS_PEQ_BYPASS		(1<<5)	//	bypass par eq
#define	BUS_EQ_FLAGS_SHELFEQ_BYPASS	(1<<8)	//	bypass shelfing eq
#define	BUS_EQ_FLAGS_HPF_BYPASS		(1<<11)	//	bypass hpf

#define	OUT_EQ_FLAGS_PEQ_BYPASS		BUS_EQ_FLAGS_PEQ_BYPASS	//	bypass par eq
#define	OUT_EQ_FLAGS_SHELFEQ_BYPASS	BUS_EQ_FLAGS_SHELFEQ_BYPASS	//	bypass shelfing eq
#define	OUT_EQ_FLAGS_HPF_BYPASS		BUS_EQ_FLAGS_HPF_BYPASS	//	bypass hpf

#define	EQ_FLAGS_GEQ_BYPASS		BUS_EQ_FLAGS_GEQ_BYPASS	//	bypass par eq
#define	EQ_FLAGS_PEQ_BYPASS		BUS_EQ_FLAGS_PEQ_BYPASS	//	bypass par eq
#define	EQ_FLAGS_SHELFEQ_BYPASS	BUS_EQ_FLAGS_SHELFEQ_BYPASS	//	bypass shelfing eq
#define	EQ_FLAGS_HPF_BYPASS		BUS_EQ_FLAGS_HPF_BYPASS	//	bypass hpf

#define SYS_SECURITY_KEYLOCK	(1<<0)

#define INFO_START					(1024)	// INFO should name LOCAL, because it will worked for sole in the network listener thread only
#define	INFO_PROPERTIES_BUS			(1024)	//°	1024,<from_connid>,<busid>
#define	INFO_PROPERTIES_BUS_EQ		(1025)	//°	1025,<from_connid>,<busid>
#define	INFO_LSP_TREE				(1026)	//°	1026,<from_connid>,<lspid or -1 for all>
#define	INFO_OUT_GROUP_CONFIG		(1027)	//°	1027,<from_connid>,<group_lsp>
#define	INFO_OUT_MUTE				(1028)	//*	1028,<from_connid>,<group_lsp>,<part=0|full=1>,<out ch 0 mute (0=unmute|1=mute|-1=not affected)>,...,<out ch 7 mute>
#define	INFO_SYS					(1029)	//°	1029,<from_connid>
#define	INFO_PRJ_TREE				(1030)	//°	1030,<from_connid>,<project_id or -1 for all>
#define	INFO_LSP_PROP				(1031)	//°	1031,<from_connid>,<lspid>,<unlock_code>
#define	INFO_PROPERTIES_OUT_GROUP_EQ (1032)	//°	1032,<from_connid>,<group_lsp>
#define	INFO_PLY_TREE				(1033)	//° 1033,<from_connid>
#define	LOCAL_PRJ_USB_EXPORT		(1034)	//° 1034,<from_connid>,<project_id>		[server will respond with COMMAND_PRJ_USB_EXPORT_ACK and same project_id if export finished successfull or with project_id=-1 on error]
#define	LOCAL_PRJ_USB_IMPORT		(1035)	//° 1035,<from_connid>,<file_id>	[file_id=0: get file list (COMMAND_PRJ_USB_FILE_xxx)]	[server will respond with COMMAND_PRJ_USB_IMPORT_ACK and same file_id if import finished successfull or with file_id=-1 on error]
#define	INFO_VERSION				(1036)	//	1036,<from_connid>[*:,<model>,<hardware_version>,<fpga_dsp_version>,<fpga_io_version>,<server_version>,<ethmacmsb>,<ethmaclsb>,<linux_version_string>] [all version numbers are hex: 00.00 e.g. 0200 for 2.0 or 022a for 2.2a BUT linux_version_string is a string; ethmac is hex]
#define	INFO_ALL					(1037)	//°	1037,<from_connid>
#define INFO_PRJ_DESC				(1038)	//°	1038,<from_connid>,<project_id|-1=actual> [invokes COMMAND_PRJ_DESC]

#ifdef HDLM_WEBDEMO
#define	INFO_USER_COUNT				(1039)	//*	1039,<from_connid>,<user count>,<max users>
#endif

#define COMMAND_BY_USER					(0)		// default
#define	COMMAND_BY_MACHINE				(1) 	// command was set by incoming udp network link group broadcast, so don't broadcast this
#define	CONNID_NO_BROADCAST				(-127)	// do not broadcast with this connid
                                    	
#define	ERR_USB_NO_DEVICE				(-1)
#define	ERR_OPEN_DB						(-2)	// cannot open database
#define	ERR_CREATE_DB					(-3)	// cannot create database
#define ERR_ATT_DB						(-4)	// cannon attach database
#define	ERR_PRJ							(-5)	// commond project read error
#define	ERR_INVALID_FILE				(-6)	// invalid file

#define MSG_LEVEL_INFO					(0)
#define MSG_LEVEL_WARN					(1)
#define MSG_LEVEL_ERR					(2)

#define	SYS_BUS_LABEL_SIZE				(201)	// space for escaped symbols (*4+1)
#define	SYS_BUS_LABEL_SIZE_REAL			(12)	// max. unescaped characters
#define	SYS_BUS_LABEL_SIZE_S			"201"
#define	SYS_LSP_LABEL_SIZE				(201)
#define	SYS_LSP_LABEL_SIZE_REAL			(50)
#define	SYS_LSP_LABEL_SIZE_S			"201"
#define	SYS_OUT_LABEL_SIZE				(201)
#define	SYS_OUT_LABEL_SIZE_REAL			(12)
#define	SYS_OUT_LABEL_SIZE_S			"201"
#define	SYS_MISC_DEVICENAME_SIZE		(201)
#define	SYS_MISC_DEVICENAME_SIZE_REAL	(50)
#define	SYS_MISC_DEVICENAME_SIZE_S		"201"
#define	SYS_NET_WLAN_PASSWORD_SIZE		(64*4+1)
#define	SYS_NET_WLAN_PASSWORD_SIZE_REAL	(64)
#define	SYS_NET_WLAN_PASSWORD_SIZE_S	"257"
#define	SYS_PROJECTNAME_SIZE			(201/*81*/)	// space for escaped symbols (*4+1)
#define	SYS_PROJECTNAME_SIZE_REAL		(50/*20*/)	// max. unescaped characters
#define	SYS_PROJECTNAME_SIZE_S			"201"/*"81"*/
#define	SYS_PROJECTDESC_SIZE			(4097)
#define	SYS_PROJECTDESC_SIZE_REAL		(1024)
#define	SYS_PROJECTDESC_SIZE_S			"4097"
#define	SYS_MESSAGE_SIZE				(1025)	// space for escaped symbols (*4+1)
#define	SYS_MESSAGE_SIZE_REAL			(256)	// max. unescaped characters
#define	SYS_MESSAGE_SIZE_S				"1025"
#define	SYS_MISC_DELAYUNIT_METER		(0)
#define	SYS_MISC_DELAYUNIT_FEET			(1)
#define	SYS_MISC_DELAYUNIT_MILLISECONDS (2)
#define	SYS_BUS_COUNT					(8)
#define	SYS_OUT_COUNT					(8)
#define	DSP_CURVES_FREQ_LOW				(17.5)
#define	DSP_CURVES_FREQ_HIGH			(24250)
#define	DSP_CURVES_WIDTH				(128)
#define SYS_EQ_FREQ_MIN					(16)
#define	SYS_EQ_FREQ_MAX					(24000)

#ifdef __ANDROID__
#include <android/log.h>
#define log(args...) __android_log_print(ANDROID_LOG_INFO, "hdlm_api", args)
#define err(args...) __android_log_print(ANDROID_LOG_ERROR, "hdlm_api", args)
#else
#ifdef __IOS__
#include <stdio.h>
#define log(args...) printf(args),printf("\n")
#define err(args...) printf(args),printf("\n")
#else
#ifdef __MINGW32__
#include <stdio.h>
#define log(args...) printf(args),printf("\n")
#define err(args...) printf("!!! ERROR !!! "),printf(args),printf("\n")
#else
#include <stdio.h>
#define log(args...) printf(args),printf("\n")
#define err(args...) fprintf(stderr, args),printf("\n")
#endif
#endif
#endif

typedef void (*listener_t)(void *par, void *user);

struct arg_out_meter {
	int		out_id;
	float	peak_db;
	float	gr_db;
	int		conn_id;
};

struct arg_bus_meter {
	int		bus_id;
	float	peak_db;
	float	gr_db;
	int		conn_id;
};

struct arg_bus_label {
	int		bus_id;
	char 	label[SYS_BUS_LABEL_SIZE+1];
	char 	label_upper[SYS_BUS_LABEL_SIZE+1];	//	utf-correctly upper-cased
	int		conn_id;
};

struct arg_bus_mute {
	int		bus_id;
	int		mute;
	int		conn_id;
};

struct arg_bus_gain {
	int		bus_id;
	float	gain;
	int		conn_id;
};

struct arg_bus_phase {
	int		bus_id;
	int		phase;
	int		conn_id;
};

struct arg_bus_comp_thres {
	int		bus_id;
	float	thres;
	int		conn_id;
};

struct arg_bus_comp_ratio {
	int		bus_id;
	float	ratio;
	int		conn_id;
};

struct arg_bus_peak_overshoot {
	int		bus_id;
	float	overshoot;
	int		conn_id;
};

struct arg_bus_comp_attack {
	int		bus_id;
	float	attack;
	int		conn_id;
};

struct arg_bus_comp_release {
	int		bus_id;
	float	release;
	int		conn_id;
};

struct arg_bus_peak_release {
	int		bus_id;
	float	peakrelease;
	int		conn_id;
};

struct arg_bus_comp_knee {
	int		bus_id;
	float	knee;
	int		conn_id;
};

struct arg_bus_group_local {
	int		bus_id;
	int		group_local;
	int		conn_id;
};

struct arg_bus_group_net {
	int		bus_id;
	int		group_net;
	int		conn_id;
};

struct arg_bus_patch {
	int		bus_id;
	int		patch;
	int		conn_id;
};

struct arg_out_grouping {
	int		group_lsp[SYS_OUT_COUNT];
	int		id_lsp[SYS_OUT_COUNT];
	int		conn_id;
};

struct arg_out_group_config {
	int		group_lsp;
	int		outmode[SYS_OUT_COUNT];
	int		conn_id;
};


struct arg_out_group_lsp_label {
	int		group_lsp;
	char 	label[SYS_LSP_LABEL_SIZE+1];
	char 	label_upper[SYS_LSP_LABEL_SIZE+1];	//	utf-correctly upper-cased
	int		conn_id;
};

struct arg_out_group_label {
	int		group_lsp;
	char 	label[SYS_OUT_LABEL_SIZE+1];
	char 	label_upper[SYS_OUT_LABEL_SIZE+1];	//	utf-correctly upper-cased
	int		conn_id;
};

struct arg_out_group_gain {
	int		group_lsp;
	float	gain;
	int		conn_id;
};

struct arg_out_group_phase {
	int		group_lsp;
	int		phase;
	int		conn_id;
};

struct arg_out_group_grp_local {
	int		group_lsp;
	int		group_local;
	int		conn_id;
};

struct arg_out_group_grp_net {
	int		group_lsp;
	int		group_net;
	int		conn_id;
};

struct arg_out_group_input {
	int		group_lsp;
	int		input_bus;
	int		conn_id;
};

struct arg_out_group_delay {
	int		group_lsp;
	float	delay;
	int		conn_id;
};

struct arg_out_group_delay_ms {
	int		group_lsp;
	float	delay_ms;
	int		conn_id;
};

struct arg_out_mute {
	int		out_id;
	int		mute;
	int		conn_id;
};

struct arg_lsp_file {
	int		lsp_id;
	int		id_parent;
	int		is_used;
	int		is_folder;
	int		is_locked;
	int		ways;
	char 	label[SYS_LSP_LABEL_SIZE+1];
	char 	label_upper[SYS_LSP_LABEL_SIZE+1];	//	utf-correctly upper-cased
	int		conn_id;
};

struct arg_lsp_file_start {
	int		partial;
	int		conn_id;
};

struct arg_lsp_file_end {
	int		conn_id;
};

struct arg_sys_network {
	int		dhcp_ip[4];
	int 	mode;
	int		wifi_on;
	int		ip[4];
	int		netmask_bits;
	int		gateway[4];
	int		conn_id;
};

struct arg_sys_servicemode {
	int		on;
	int		conn_id;
};

struct arg_sys_devicename {
	char 	device_name[SYS_MISC_DEVICENAME_SIZE+1];
	char 	device_name_upper[SYS_MISC_DEVICENAME_SIZE+1];	//	utf-correctly upper-cased
	int		conn_id;
};

struct arg_sys_wlan_password {
	char 	wlan_password[SYS_NET_WLAN_PASSWORD_SIZE+1];
	int		conn_id;
};

struct arg_sys_delayunit {
	int		delay_unit;
	float	delay_temp;
	float	delay_max;
	int		conn_id;
};

struct arg_sys_amplifiers {
	int		outid;
	int		gain;
	int		peak_voltage;
	int		conn_id;
};

struct arg_prj_file {
	int		project_id;
	int		is_locked;
	char 	label[SYS_PROJECTNAME_SIZE+1];
	char 	label_upper[SYS_PROJECTNAME_SIZE+1];	//	utf-correctly upper-cased
	int		conn_id;
};

struct arg_prj_file_start {
	int		partial;
	int		conn_id;
};

struct arg_prj_file_end {
	int		conn_id;
};

struct arg_prj_usb_export_ack {
	int		conn_id;
	int		project_id;
};

struct arg_prj_usb_import_ack {
	int		conn_id;
	int		file_id;
};

struct arg_prj_usb_file {
	int		file_id;
	int		reserved;
	char 	label[SYS_PROJECTNAME_SIZE+1];
	char 	label_upper[SYS_PROJECTNAME_SIZE+1];	//	utf-correctly upper-cased
	int		conn_id;
};

struct arg_prj_usb_file_start {
	int		partial;
	int		conn_id;
};

struct arg_prj_usb_file_end {
	int		conn_id;
};

struct arg_prj_stat {
	int		project_id;
	int		is_locked;
	int		save_is_locked;
	int		is_dirty;
	char 	label[SYS_PROJECTNAME_SIZE+1];
	char 	label_upper[SYS_PROJECTNAME_SIZE+1];	//	utf-correctly upper-cased
	int		conn_id;
};

struct arg_prj_files_dirty {
	int		conn_id;
};

struct arg_sys_message {
	int		type;
	char 	msg[SYS_MESSAGE_SIZE+1];
	int		conn_id;
};

struct arg_sys_fwupdate {
	int		key;
	int		conn_id;
};

struct arg_eq_curve {
	int		id;
	float	curve[DSP_CURVES_WIDTH];
	int		conn_id;
};

struct arg_geq_set {
	int		id;
	int		eq_id;
	float	gain;
	int		conn_id;
};

struct arg_peq_set {
	int		id;
	int		eq_id;
	float	freq;
	float	q;
	float	gain;
	int		bypass;
	int		conn_id;
};

struct arg_shelfeq_set {
	int		id;
	int		eq_id;
	float	freq;
	float	gain;
	int		bypass;
	int		conn_id;
};

struct arg_hpf_set {
	int		id;
	float	freq;
	int		type;
	int		bypass;
	int		conn_id;
};

struct arg_eq_flags {
	int		id;
	int		flags;
	int		conn_id;
};

struct arg_sys_security {
	int		flags;
	int		conn_id;
};

struct arg_sys_digitalmode {
	int		flags;
	int		conn_id;
};

struct arg_sys_flags {
	int		flags;
	int		conn_id;
};

struct arg_sys_inputstate {
	int		analog_overflow;
	int		digital_state;
	int		conn_id;
};

struct arg_sys_info {
	unsigned int	model;
	unsigned int	hardware_version;
	unsigned int	fpga_dsp_version;
	unsigned int 	fpga_io_version;
	unsigned int	server_version;
	unsigned int	ethmacmsb;
	unsigned int	ethmaclsb;
	char			linux_version_string[128];
	int				conn_id;
};

int hdlm_api_init(void);
void hdlm_api_exit(void);
int hdlm_api_connect(const char *ip_addr, int *conn_id);
void hdlm_api_disconnect(int net_handle);
void hdlm_api_add_listener(const int command_id, listener_t work_listener, void *user);
int hdlm_api_read_nonblock(int net_handle, const int conn_id);
int hdlm_api_write(int handle, const char *buf);
	
#endif
